import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { queryResponse } from "../../util/processResponse.js";

const initialState = {
    orderDetails: {},
    loading: false,
};

export const getOrderDetails = createAsyncThunk(
    "user/getOrderDetails",
    async (obj) => {
        const { access_token, URL } = obj;
        const response = await queryResponse(URL, "GET", access_token);
        return response;
    }
);

const getOrderDetailsSlice = createSlice({
    name: "user",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(getOrderDetails.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getOrderDetails.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records } = payload;
            if (code === 200) {
                state.orderDetails = records.data;
            }
            state.loading = false;
        });
        builder.addCase(getOrderDetails.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default getOrderDetailsSlice.reducer;
